package de.disag.jsoninterface;

import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class BroadcastListener {

	public static void main(String[] args) {
		int nPort = 30169;
		
		if (args.length > 0) {
			nPort = Integer.parseInt(args[0]);
		}
		
		try {
			DatagramSocket dsocket = new DatagramSocket(nPort);
			byte[] buffer = new byte[4096];
			
			DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
			
			while (true) {
		        dsocket.receive(packet);
	
		        String msg = new String(buffer, 0, packet.getLength());
		        System.out.println(packet.getAddress().getHostName() + ": " + msg);
	
		        packet.setLength(buffer.length);
		    }
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
